#ifndef _MAINVIEWDLG_H
#define _MAINVIEWDLG_H

#include "afxcmn.h"
#include "afxwin.h"
#include <vector>
using namespace std;

#include "Include/CLS_NetAdmin_Interface.h"
#include "SettingDialog.h"
#include "CLS_FileReader.h"
#include "CLS_MP4FileReader.h"
#include "CLS_SdvFileReader.h"
#include "CLS_DlgPicSnap.h"

class CSearchNVS;

#define MSG_EVENT 	WM_USER+1
#define MSG_ADDNVSITEM	WM_USER+2
#define MARCO_MSG_CHANNEL	0x0FF0
#define STATE_OFFLINE	0
#define STATE_ONLINE	1
#define STATE_CONNECT	2

#define MAX_DECPDER_NUM 256
#define TIMER_PUSH_STREAM 1
#define  TIMER_SOUND_CONTROL 2
#define MAX_FRAME_BUFFER 512*1024
#define MAX_PUSH_STREAM_BUFFER 256

#define PORT_ALARM_BEGIN_LEFT 310
#define PORT_ALARM_BEGIN_TOP 510
#define PORT_ALARM_ICON_SIZE 16
#define PORT_ALARM_DISTANCE 24
#define PORT_ALARM_LINE     4

#define PORT_ALARM_COLOR RGB(255, 0, 0)
#define PORT_DISALARM_COLOR RGB(255, 255, 255)

struct st_PushStream
{
	long    m_lPushID;
	int     m_iChan;
	int     m_iWindow;
	CLS_FileReader* m_pFile;
	BOOL     m_bStart;
	int		m_iSpeed;
	bool	m_bFlagAudio;
};

struct st_Decoder
{
	CString m_astrUser;
	char m_cIP[32];
	int  m_iPort;
	int  m_bStayPass;
	//CString m_astrUser;
	CString m_astrPass;
	long m_lID;
	st_PushStream   m_stPush[DEC_MAX_CHANNEL_TOTAL_NUM][DEC_MAX_WINDOW_TOTAL_NUM];
	st_Decoder()
	{
		int i,j;
		memset(m_cIP,0,sizeof(m_cIP));
		m_iPort = 3000;
		m_bStayPass = 0;
		m_astrUser = "";
		m_astrPass = "";
		m_lID = -1;
		for(i=0; i<(DEC_MAX_CHANNEL_TOTAL_NUM); i++)
			for(j=0; j<DEC_MAX_WINDOW_TOTAL_NUM; j++)
			{
				st_PushStream& tPush = m_stPush[i][j];
				tPush.m_lPushID = -1;
				tPush.m_pFile = NULL;
				tPush.m_bStart = FALSE;
				tPush.m_iSpeed = 0;
				tPush.m_bFlagAudio = false;
				tPush.m_iChan = i;
				tPush.m_iWindow = j;
			}
	};
};

struct st_NextItem
{
	int m_iDecID;
	int m_iChan;
	int m_iPic;

	//TNVSITEMEX m_viewItem;           //˫ʱҪӵķ
	ViewServerInfo m_tViewServer;
	st_NextItem()
	{
		m_iDecID = -1;
		m_iChan = -1;
		m_iPic = -1;
		//memset(&m_viewItem,0,sizeof(m_viewItem));
		//m_viewItem.m_iStructLen = sizeof(TNVSITEMEX);
		memset(&m_tViewServer, 0, sizeof(m_tViewServer));
	}
};


// CMainViewDlg dialog
class CMainViewDlg : public CDialog
{
	DECLARE_DYNAMIC(CMainViewDlg)

public:
	CMainViewDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CMainViewDlg();

	enum { IDD = IDD_DIALOG_MAIN };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	int		InitDecoder(int _iFlag, void* _pvValue);

	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	//afx_msg LRESULT OnMainMsg(WPARAM _wParam,LPARAM _lParam);
	afx_msg LRESULT OnAddNVSMsg(WPARAM _wParam,LPARAM _lParam);
	afx_msg LRESULT OnMainNotify( WPARAM _wParam, LPARAM _lParam );
	afx_msg LRESULT OnChangeParamNotify( WPARAM _WParam,LPARAM _LParam );
	afx_msg LRESULT CMainViewDlg::OnFindDevice( WPARAM _WParam,LPARAM _LParam );
	afx_msg void OnNMRClickTreeDecoder(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMDblclkTreeDecoder(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTvnSelchangedTreeDecoder(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMRClickListNvs(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMDblclkListNvs(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnCbnSelchangeComboPos();
	afx_msg void OnBnClickedButtonManualAdd();
	afx_msg void OnBnClickedButtonAutoSearch();
	afx_msg void OnBnClickedButtonCtrl();
	afx_msg void OnBnClickedButtonAdd();
	afx_msg void OnBnClickedButtonModify();
	afx_msg void OnBnClickedButtonDelete();
	afx_msg void OnBnClickedButtonConnect();
	afx_msg void OnBnClickedButtonDisconnect();
	afx_msg void OnBnClickedButtonAudio();
	afx_msg void OnBnClickedButtonTalk();
	afx_msg void OnBnClickedButtonAutoSwitch();
	afx_msg void OnBnClickedButtonPushStream();
	afx_msg void OnBnClickedButtonIntelligentAdd();
	afx_msg void OnLogon();
	afx_msg void OnLogoff();
	afx_msg void OnSet();
	afx_msg void OnPassword();
	afx_msg void OnReboot();
	afx_msg void OnDelete();
	afx_msg void OnNvsConnect();
	afx_msg void OnNvsDisconnect();
	afx_msg void OnNvsModify();
	afx_msg void OnNvsDelete();
	afx_msg void OnScreen1();
	afx_msg void OnScreen2();
	afx_msg void OnScreen4();
	afx_msg void OnScreen0();
	afx_msg void OnScreen3();
	afx_msg void OnScreen6();
	afx_msg void OnScreen8();
	afx_msg void OnScreen9();
	afx_msg void OnScreen16();
	afx_msg void OnScreen10();
	afx_msg void OnScreen13();
	afx_msg void OnScreen20A();
	afx_msg void OnScreen20B();
	afx_msg void OnScreen25();
	afx_msg void OnScreen36();
	afx_msg void OnScreen40();
	afx_msg void OnScreen64();
	afx_msg void OnScreen81();
	afx_msg void OnScreen100();
	void InnerPush();
	int InnerStopPush(st_PushStream* _pStream);
	int DeletePush(st_PushStream* _pPush);
	int AddPush(st_PushStream* _pPush);
	int InnerStartpPush(st_PushStream* tStream);
	st_PushStream* FindPushStream(int _iID, int _iPushID);
	int AddDecoder(st_Decoder* _pDecoder);
	int DeleteDecoder(HTREEITEM _hItem);
	int ModifyNvsItem(int _iItem,TNVSITEMEX& _tNvsItemEx);
	int ModifyNvsServer(int _iItem, ViewServerInfo& _tNvsServer);
	static int MainNotify(unsigned long _lID, unsigned int _uiMsg, unsigned int _iChannel, int _iPos, void* _pvParam, int _iParamSize, void* _pvUserData); 
	static void __stdcall FindServer(PTDEVICE _pDevice);
	static int ChangeParamNotify(unsigned long _lID, unsigned int _uiMsg, unsigned int _iChannel, int _iPos, void* _pvParam, int _iParamSize, void* _pvUserData);
	void LockPush();
	void UnlockPush();
	int InitPushStream();
	int StopPushStream();
	void CmdPicSnap(int _iCmd,int _iSnapID);
private:
	int GetCurrentID();
	int GetCurrentChannel();
	int GetCurrentPos();
	st_Decoder* GetDecoder(char* _cIP);
	st_Decoder* GetDecoder(int _iID);
	st_Decoder* GetCurrentDecoder();
	HTREEITEM FindItem(CString _strItem);
	HTREEITEM FindItem(int _iID);
	int DeleteAllChild(HTREEITEM _hItem);
	int AddNvsItem(int iType, ServerItem& _tNvsItem);
	int GetNvsItem(int _iItem,TNVSITEMEX& _tNvsItem);
	int GetNvsServer(int _iItem, ViewServerInfo& _tNvsServer);
	int Logon(HTREEITEM _hItem,BOOL _bShow = FALSE);
	int Logoff(HTREEITEM _hItem);
	int Connect(int _iItem);
	int Disconnect(int _iItem);
	int ModifyNvs(int _iItem,TNVSITEMEX& _tNvsItemEx);
	int ModifyNvsEx(int _iItem, ViewServerInfo& _tNvsServer);
	int DeleteNvs(int _iItem);
	int UpdateChannelInfo(int _iID,int _iChannel,int _iPos);
	int UpdateNVSItem(int _iItem, int iType, ServerItem& _tNvsItem);
	int UpdateNvsServer(int _iItem, ViewServerInfo& _tNvsServer);
	int UpdateNVSItems(int _iID,int _iChannel,int _iPos);
	int UpdateDECVersion(int _iID);
	int UpdateDECPos(int _iID,int _iChannel,int _iPos);
	int UpdateDECInfo(int _iID,int _iChannel,int _iPos);
	int UpdateNVSItemStatus(int _iID,int _iChannel,int _iPos);
	int UpdateChannelMode(int _iID,int _iChannel,int _iPicNum, int _iMode = 0);
	int UpdateAudioStatus(int _iID,int _iChannel,int _iPos);
	int UpdateTalkStatus(int _iID,int _iChannel,int _iPos);
	int UpdateSwitchStatus(int _iID,int _iChannel,int _iPos);
	int UpdatePushStreamAudioStatus(int _iID,int _iChannel,int _iPos);
	void UpdatePosNum(int iLogonId, int iChannel);


	/************************************************************************/
	/*                              NVDϢ                         */
	/************************************************************************/
	int LogonNotify(int _iID,int _iStatus);
	int StartViewNotify(int _iID,int _iChannel,int _iPos); 
	int StopViewNotify(int _iID,int _iChannel,int _iPos); 
	int TalkNotify(int _iID,int _iChannel,int _iPos,int _iStatus); //_iStatus: 1:ɹ 0:ʧ
	int ErrorOrderNotify(int _iID);
	int ParamChangeNotify(int _iID);
	int AudioNotify(int _iID,int _iChannel,int _iPos);
	int PushStreamNotify(int _iID,int _iPushID, int _iStart);
	int ChangePassNotify(int _iID,int _iResult);
	int ChangeAlarmNotify(int _iID);
	int CreatevvoNotify(int _iID);
	int UpdataChannelState(int _iID);

	void SaveDecoderList();
	void LoadDecoderList();
	void ChangeAlarmState();
	int UpdatePopUpWindow();
	void PicsnapNotify(_MAIN_NOTIFY_DATA* _pData);
	

private:
	HBRUSH	m_brBkGround;
	CTreeCtrl m_tvDecoder;
	CListCtrl m_lstNvs;
	CComboBox m_cboPos;
	CImageList m_lstImg;
	CButton m_chkLastFrame;
	vector<st_Decoder* >  m_VecDecoder;                      //洢еĽ
	vector<st_PushStream*> m_vecPushStream;
	st_NextItem m_tNextItem;
	CSettingDialog*      m_pDlgSetting;
	bool		m_bAlreadyTipErr;
	CSearchNVS*			 m_pDlgSearchNVS;
	CLS_DlgPicSnap *m_pDlgPicSnap;

	static CMainViewDlg* s_pSelf;

	int		m_iIsOCX;
	bool	m_bAddNVSing;
	
	CButton m_chkEncryptKey;

	int    m_iPortAlarm[DEC_MAX_PORT_NUM];
	CBrush m_brAlarmColor;
	CBrush m_brDisAlarmColor;
	CRITICAL_SECTION m_csPush;
	BOOL m_bRunPush;

public:
	afx_msg void OnBnClickedCheckEncryptkey();
private:
	CEdit m_edtEncryptKey;
public:
	afx_msg void OnBnClickedButtonFastplay();
	afx_msg void OnBnClickedButtonSlowplay();
private:
	//int m_iSpeed[DEC_MAX_CHANNEL_NUM][DEC_MAX_PICTURE_NUM];
	HANDLE m_hPushThread;
	unsigned int m_dwThreadID;
	static unsigned int WINAPI PushStramThread(LPVOID _Param);
	bool m_bPushFlag;
	//HANDLE m_hPushThread[DEC_MAX_CHANNEL_NUM][DEC_MAX_PICTURE_NUM];
	//unsigned int m_dwThreadID[DEC_MAX_CHANNEL_NUM][DEC_MAX_PICTURE_NUM];
	//bool m_bPushFlag[DEC_MAX_CHANNEL_NUM][DEC_MAX_PICTURE_NUM];
	int m_iLastID;
	int m_iLastChannel;
	int m_iLastPos;

public:
	afx_msg void OnPaint();
protected:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
public:
	afx_msg void OnBnClickedButton1();
	CButton m_btnSetUp;
	CButton m_btnSetDown;
	afx_msg void OnBnClickedBtnSetUp();
	afx_msg void OnBnClickedBtnSetDown();
	int UpdateDECPosEx(int _iID,int _iChannel,int _iPos);
	int PushStreamData();
	int PushFile(st_PushStream*  tPush);

	void UpdateSinglePicture();
private:
	CComboBox m_cboSinglePic;
public:
	afx_msg void OnCbnSelchangeComboSignal();
	afx_msg void OnBnClickedButtonSdkWorkMode();
private:
	CComboBox m_cboSdkWorkMode;
public:
	afx_msg void OnBnClickedButtonSyncLoopctrl();
	CButton m_chk_SaveCfg;
private:
	CButton m_chkPsStream;
public:
	afx_msg void OnBnClickedBtnPicsnap();
};

#endif